{* Guía visual de documentación adaptada a PrestaShop con soporte i18n en runtime para EN *}
{if !isset($img_base)}{assign var=img_base value=$module_dir|cat:'views/img/' }{/if}

<div class="porto-admin-card wb-settings-onboarding">
  <h2 class="whatsboost-docs-h2" data-i18n="docs.title">{l s='Documentación' mod='whatsboost'}</h2>

  <div class="whatsboost-docs-callout whatsboost-docs-callout--primary whatsboost-docs-callout--wide porto-admin-card wb-settings-onboarding" style="margin-top:10px;">
    <p style="margin:0;font-weight:600;color:#0f172a;" data-i18n="docs.freeplan">
      {l s='Plan Gratis activo al registrarte o iniciar sesión.' mod='whatsboost'}
    </p>
  </div>

  <h3 class="whatsboost-docs-h2" style="margin-top:12px;" data-i18n="docs.quickguide">{l s='Guía rápida (3 pasos)' mod='whatsboost'}</h3>

  {* PASO 1 *}
  <div class="whatsboost-docs-callout whatsboost-docs-callout--primary whatsboost-docs-callout--wide porto-admin-card wb-settings-onboarding">
    <h3 class="whatsboost-docs-h2" style="margin-top:12px;" data-i18n="step1.title">1) {l s='Regístrate o inicia sesión' mod='whatsboost'}</h3>
    <ul style="margin:0 0 10px 18px;list-style:disc;">
      <li>
        <span data-i18n="step1.noaccount">{l s='Si no tienes cuenta:' mod='whatsboost'}</span>
        <a href="https://whatsboost.net/dashboard/auth/register" target="_blank" rel="noopener noreferrer" data-i18n="step1.create">{l s='crear cuenta' mod='whatsboost'}</a>.
      </li>
    </ul>
    <div class="whatsboost-docs-row">
      <figure>
        <div class="wb-browser-frame">
          <div class="wb-browser-bar"><span class="wb-dot"></span><span class="wb-dot"></span><span class="wb-dot"></span></div>
          <div class="wb-browser-body">
            <img loading="lazy" class="whatsboost-docs-img js-wb-zoom" src="{$img_base}registrarse.PNG" alt="{l s='Pantalla de registro' mod='whatsboost'}" data-i18n-alt="img.signup" />
          </div>
        </div>
        <figcaption class="whatsboost-docs-caption" data-i18n="img.signup">{l s='Pantalla de registro' mod='whatsboost'}</figcaption>
      </figure>
    </div>
    <ul style="margin:10px 0 10px 18px;list-style:disc;">
      <li>
        <span data-i18n="step1.hasaccount">{l s='Si ya tienes cuenta:' mod='whatsboost'}</span>
        <a href="https://whatsboost.net/dashboard/auth" target="_blank" rel="noopener noreferrer" data-i18n="step1.login">{l s='inicia sesión' mod='whatsboost'}</a>.
      </li>
    </ul>
    <div class="whatsboost-docs-row">
      <figure>
        <div class="wb-browser-frame">
          <div class="wb-browser-bar"><span class="wb-dot"></span><span class="wb-dot"></span><span class="wb-dot"></span></div>
          <div class="wb-browser-body">
            <img loading="lazy" class="whatsboost-docs-img js-wb-zoom" src="{$img_base}iniciarSesion.PNG" alt="{l s='Pantalla de iniciar sesión' mod='whatsboost'}" data-i18n-alt="img.signin" />
          </div>
        </div>
        <figcaption class="whatsboost-docs-caption" data-i18n="img.signin">{l s='Pantalla de iniciar sesión' mod='whatsboost'}</figcaption>
      </figure>
    </div>
  </div>

  {* PASO 2 *}
  <div class="whatsboost-docs-callout whatsboost-docs-callout--primary whatsboost-docs-callout--wide porto-admin-card wb-settings-onboarding">
    <h4 class="whatsboost-docs-h2" style="margin:0 0 8px;" data-i18n="step2.title">2) {l s='Crea una clave (API Key)' mod='whatsboost'}</h4>
    <ul style="margin:0 0 10px 18px;list-style:disc;">
      <li>
        <span data-i18n="step2.leftmenu">{l s='1-En el menú izquierdo entra en ' mod='whatsboost'}</span><strong data-i18n="step2.keys">CLAVES&nbsp;API</strong> <span data-i18n="step2.or">{l s='o ve a' mod='whatsboost'}</span>
        <a href="https://whatsboost.net/dashboard/tools/keys" target="_blank" rel="noopener noreferrer" data-i18n="step2.thispage">{l s='esta página' mod='whatsboost'}</a>.
      </li>
      <li data-i18n="step2.addkey">{l s='2-Pulsa "Añadir clave".' mod='whatsboost'}</li>
    </ul>
    <div class="whatsboost-docs-row">
      <figure>
        <div class="wb-browser-frame">
          <div class="wb-browser-bar"><span class="wb-dot"></span><span class="wb-dot"></span><span class="wb-dot"></span></div>
          <div class="wb-browser-body">
            <img loading="lazy" class="whatsboost-docs-img js-wb-zoom" src="{$img_base}pintada1.PNG" alt="{l s='Formulario para nombrar la clave' mod='whatsboost'}" data-i18n-alt="img.namekey" />
          </div>
        </div>
        <figcaption class="whatsboost-docs-caption" data-i18n="img.namekey">{l s='Formulario para nombrar la clave' mod='whatsboost'}</figcaption>
      </figure>
    </div>
    <ul style="margin:10px 0 10px 18px;list-style:disc;">
      <li data-i18n="step2.write">{l s='Escribe un nombre (cualquiera, solo para reconocerla) y guarda.' mod='whatsboost'}</li>
    </ul>
    <div class="whatsboost-docs-row">
      <figure>
        <div class="wb-browser-frame">
          <div class="wb-browser-bar"><span class="wb-dot"></span><span class="wb-dot"></span><span class="wb-dot"></span></div>
          <div class="wb-browser-body">
            <img loading="lazy" class="whatsboost-docs-img js-wb-zoom" src="{$img_base}pintada2.PNG" alt="{l s='Poner nombre' mod='whatsboost'}" data-i18n-alt="img.setname" />
          </div>
        </div>
        <figcaption class="whatsboost-docs-caption" data-i18n="img.setname">{l s='Poner nombre' mod='whatsboost'}</figcaption>
      </figure>
      <figure>
        <div class="wb-browser-frame">
          <div class="wb-browser-bar"><span class="wb-dot"></span><span class="wb-dot"></span><span class="wb-dot"></span></div>
          <div class="wb-browser-body">
            <img loading="lazy" class="whatsboost-docs-img js-wb-zoom" src="{$img_base}pintada3.PNG" alt="{l s='Clave creada' mod='whatsboost'}" data-i18n-alt="img.keycreated" />
          </div>
        </div>
        <figcaption class="whatsboost-docs-caption" data-i18n="img.keycreated">{l s='Clave creada' mod='whatsboost'}</figcaption>
      </figure>
    </div>
  </div>

  {* PASO 3 *}
  <div class="whatsboost-docs-callout whatsboost-docs-callout--primary whatsboost-docs-callout--wide porto-admin-card wb-settings-onboarding">
    <h4 class="whatsboost-docs-h2" style="margin:0 0 8px;" data-i18n="step3.title">3) {l s='Copia tu clave y pégala en PrestaShop' mod='whatsboost'}</h4>
    <ul style="margin:0 0 10px 18px;list-style:disc;">
      <li data-i18n="step3.copyfromkeys">{l s='En CLAVES API, copia la clave que quieras usar.' mod='whatsboost'}</li>
    </ul>
    <div class="whatsboost-docs-row">
      <figure>
        <div class="wb-browser-frame">
          <div class="wb-browser-bar"><span class="wb-dot"></span><span class="wb-dot"></span><span class="wb-dot"></span></div>
          <div class="wb-browser-body">
            <img loading="lazy" class="whatsboost-docs-img js-wb-zoom" src="{$img_base}pintada4.PNG" alt="{l s='Copiar la clave' mod='whatsboost'}" data-i18n-alt="img.copykey" />
          </div>
        </div>
        <figcaption class="whatsboost-docs-caption" data-i18n="img.copykey">{l s='Copiar la clave' mod='whatsboost'}</figcaption>
      </figure>
    </div>
    <ul style="margin:10px 0 10px 18px;list-style:disc;">
      <li data-i18n="step3.backtoPS">{l s='Vuelve a tu PrestaShop, módulo WhatsBoost, pega la clave en Ajustes y guarda.' mod='whatsboost'}</li>
    </ul>
    <div class="whatsboost-docs-row">
      <figure>
        <div class="wb-browser-frame">
          <div class="wb-browser-bar"><span class="wb-dot"></span><span class="wb-dot"></span><span class="wb-dot"></span></div>
          <div class="wb-browser-body">
            <img loading="lazy" class="whatsboost-docs-img js-wb-zoom" src="{$img_base}Captura de pantalla 2025-11-06 094838.png" alt="{l s='Dónde pegar la clave - paso 1' mod='whatsboost'}" data-i18n-alt="img.where1" />
          </div>
        </div>
        <figcaption class="whatsboost-docs-caption" data-i18n="img.where1">{l s='Dónde pegar la clave - paso 1' mod='whatsboost'}</figcaption>
      </figure>
      <figure>
        <div class="wb-browser-frame">
          <div class="wb-browser-bar"><span class="wb-dot"></span><span class="wb-dot"></span><span class="wb-dot"></span></div>
          <div class="wb-browser-body">
            <img loading="lazy" class="whatsboost-docs-img js-wb-zoom" src="{$img_base}Captura de pantalla 2025-11-06 095431.png" alt="{l s='Dónde pegar la clave - paso 2' mod='whatsboost'}" data-i18n-alt="img.where2" />
          </div>
        </div>
        <figcaption class="whatsboost-docs-caption" data-i18n="img.where2">{l s='Dónde pegar la clave - paso 2' mod='whatsboost'}</figcaption>
      </figure>
    </div>
    <p style="margin:12px 0 0;">
      <a class="wb-btn wb-btn-primary" href="{$admin_base|escape:'htmlall':'UTF-8'}&wbv=settings" data-i18n="cta.settings">{l s='Ir a Ajustes' mod='whatsboost'}</a>
    </p>
  </div>

</div>

{literal}
<script>
(function(){
  try {
    var lang = (document.documentElement.getAttribute('lang')||'').toLowerCase();
    if(lang.indexOf('en') !== 0){ return; }
    var t = {
      'docs.title': 'Documentation',
      'docs.freeplan': 'Free plan active when you sign up or log in.',
      'docs.quickguide': 'Quick guide (3 steps)',
      'step1.title': '1) Sign up or log in',
      'step1.noaccount': 'If you don\'t have an account:',
      'step1.create': 'create account',
      'img.signup': 'Sign up screen',
      'step1.hasaccount': 'If you already have an account:',
      'step1.login': 'log in',
      'img.signin': 'Log in screen',
      'step2.title': '2) Create an API Key',
      'step2.leftmenu': '1-In the left menu go to ',
      'step2.keys': 'API KEYS',
      'step2.or': 'or go to',
      'step2.thispage': 'this page',
      'step2.addkey': '2-Click "Add key".',
      'img.namekey': 'Form to name the key',
      'step2.write': 'Enter a name (anything, just to recognize it) and save.',
      'img.setname': 'Set a name',
      'img.keycreated': 'Key created',
      'step3.title': '3) Copy your key and paste it in PrestaShop',
      'step3.copyfromkeys': 'In API KEYS, copy the key you want to use.',
      'img.copykey': 'Copy the key',
      'step3.backtoPS': 'Back to your PrestaShop, WhatsBoost module, paste the key in Settings and save.',
      'img.where1': 'Where to paste the key - step 1',
      'img.where2': 'Where to paste the key - step 2',
      'cta.settings': 'Go to Settings'
    };

    document.querySelectorAll('[data-i18n]').forEach(function(el){
      var k = el.getAttribute('data-i18n');
      if(t[k]){ el.textContent = t[k]; }
    });
    document.querySelectorAll('[data-i18n-alt]').forEach(function(el){
      var k = el.getAttribute('data-i18n-alt');
      if(t[k]){ el.setAttribute('alt', t[k]); }
    });
  } catch(e){}
})();
</script>
{/literal}


